<?php # $Id: serendipity_event_statistics.php 1528 2006-12-01 08:58:47Z garvinhicking $

if (IN_serendipity !== true) {
    die ("Don't hack!");
}

$probelang = dirname(__FILE__) . '/' . $serendipity['charset'] . 'lang_' . $serendipity['lang'] . '.inc.php';
if (file_exists($probelang)) {
    include $probelang;
}
include dirname(__FILE__) . '/lang_en.inc.php';


class serendipity_event_feeds_blacklist extends serendipity_event
{
    var $title = PLUGIN_FEEDS_BLACKLIST_TITLE;

    function introspect(&$propbag)
    {
        global $serendipity;

        $propbag->add('name',          PLUGIN_FEEDS_BLACKLIST_TITLE);
        $propbag->add('description',   PLUGIN_FEEDS_BLACKLIST_DESC);
        $propbag->add('stackable',     false);
        $propbag->add('author',        'Adrian Schneider');
        $propbag->add('version',       '0.1');
        $propbag->add('requirements',  array(
            'serendipity' => '0.8',
            'smarty'      => '2.6.7',
            'php'         => '4.1.0'
        ));
        $propbag->add('groups', array('BACKEND_FEATURES'));
        $propbag->add('event_hooks',    array(
            'frontend_display' => true
        ));

        $propbag->add('configuration', array(
				'active',
				'iplist',
                'logfile'
				));
    }

    function introspect_config_item($name, &$propbag)
    {
        global $serendipity;
		switch ($name) {
			case 'active':
				$propbag->add('type',           'boolean');
                $propbag->add('name',           PLUGIN_FEEDS_BLACKLIST_ACTIVE);
                $propbag->add('description',    PLUGIN_FEEDS_BLACKLIST_ACTIVE_DESC);
                $propbag->add('default',        true);                
				break;
			case 'iplist':
				$propbag->add('type',           'text');
                $propbag->add('name',           PLUGIN_FEEDS_BLACKLIST_IPLIST);
                $propbag->add('description',    PLUGIN_FEEDS_BLACKLIST_IPLIST_DESC);
                $propbag->add('default',        '');
				break;
            case 'logfile':
				$propbag->add('type',           'string');
                $propbag->add('name',           PLUGIN_FEEDS_BLACKLIST_LOGFILE);
                $propbag->add('description',    PLUGIN_FEEDS_BLACKLIST_LOGFILE_DESC);
                $propbag->add('default',        PLUGIN_FEEDS_BLACKLIST_LOGFILE_DEFAULT);
				break;
			default: return false;
		}
        return true;
    }

    function event_hook($event, &$bag, &$eventData) {
        global $serendipity;

        $hooks = &$bag->get('event_hooks');

        if (isset($hooks[$event])) {
            switch($event) {
                case 'frontend_display':
					if (preg_match('/^\/'.$serendipity['permalinkFeedsPath'].'/i', $_SERVER['REQUEST_URI'])) {
                        if ($this->is_blacklisted() && $this->get_config('active') == true) {
                            header('HTTP/1.0 403 Forbidden');
                            header('Content-Type:text/plain');
                            printf(PLUGIN_FEEDS_BLACKLIST_ACCESS_DENIED, $_SERVER['REMOTE_ADDR']);
                            exit;
                        }
                    }
                    break;

                default:
                    return false;
                    break;
            }
        } else {
            return false;
        }
    }
    
    function is_blacklisted()
    {
        $iplist = $this->get_config('iplist');
        if (!$iplist) return false;
        
        $p = explode(",", $iplist);
        foreach ((array)$p as $ip) {
            $ip = str_replace('.', '\.', trim($ip));
            $ip = str_replace('*', '.*', $ip);
            
            if (preg_match("/$ip/", $_SERVER['REMOTE_ADDR'])) {
                $this->logip($_SERVER['REMOTE_ADDR']);
                return true;
            } else {
                return false;
            }
        }
    }
    
    function logip($string)
    {
        $string = date('Y-m-d, H:i:s').' - '.$string."\n";
        $file = $this->get_config('logfile');
        if (substr($file, 0, 1) != '/')
            $file = dirname(__FILE__).'/'.$file;
            
        @$fp = fopen($file, 'a');
        @fputs($fp, $string);
        @fclose($fp);
    }

    function install(){

        //$this->createTables();

    }

    function uninstall(){

        //$this->dropTables();

    }

}

/* vim: set sts=4 ts=4 expandtab : */